package com.ejie.ab04b.control;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.ParserConfigurationException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.ConstantesDokusi;
import com.ejie.ab04b.constantes.ConstantesNum;
import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.model.DocumentoAperturas;
import com.ejie.ab04b.service.dokusi.DokusiService;
import com.ejie.ab04b.util.DokusiUtils;
import com.ejie.ab04b.util.PropertiesUtil;
import com.ejie.ab04b.util.Utilities;
import com.ejie.ab04b.util.digitalizacion.ConfigDigitalizacion;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.t65.jaxb.beans.fsd.T65BDocumentType;
import com.ejie.t65.jaxb.beans.fsd.T65BStringListType;
import com.ejie.y31.factory.Y31JanoServiceAbstractFactory;
import com.ejie.y31.service.Y31JanoService;

/**
 * 
 * @author GFI-NORTE
 * 
 */
@Controller()
@RequestMapping(value = "/digitalizacion")
public class DigitalizacionController {
	private static final Logger LOGGER = LoggerFactory
			.getLogger(DigitalizacionController.class);

	@Autowired()
	private DokusiService dokusiService;

	/**
	 * Inicio digitalizacion.
	 * 
	 * String
	 * 
	 * @return the string
	 */
	@RequestMapping(value = "/startDigi")
	public String inicioDigitalizacion() {

		DigitalizacionController.LOGGER
				.error("Entra en pantalla digitalización");
		return "startDigi";
	}

	/**
	 * Prueba subida PIF.
	 * 
	 * String
	 * 
	 * @return the string
	 */
	@RequestMapping(value = "/pruebaSubidaPIF")
	public String pruebaSubidaPIF() {

		try {
			Y31JanoService invocador = Y31JanoServiceAbstractFactory
					.getInstance();
			String fileName = "/desarrollo/datosXML.xml";
			invocador.put(
					UtilSeguridad.getInstance().getTokenDocumentXLNets(
							Constantes.APLICACION), new ByteArrayInputStream(
							Utilities.readFile(fileName).getBytes()),
					"/l61b/apps/prueba.xml", true, new Long(
							ConstantesNum.NUM_120));
		} catch (Exception e) {
			DigitalizacionController.LOGGER.error("Exception", e);
		}

		return "startDigi";
	}

	/**
	 * model Model session HttpSession res HttpServletResponse.
	 * 
	 * @param model
	 *            the model
	 * @param session
	 *            the session
	 * @param res
	 *            the res
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = "/obtenerXML", method = RequestMethod.GET, produces = "application/xml")
	public void obtenerXML(Model model, HttpSession session,
			HttpServletResponse res) throws AB04BException {

		DigitalizacionController.LOGGER.info("Entra en obtenerXML");

		ConfigDigitalizacion configuracion = new ConfigDigitalizacion();
		// integrationToken
		configuracion.setIntegrationToken(UtilSeguridad.getInstance()
				.dom2String(
						UtilSeguridad.getInstance().getTokenDocumentXLNets(
								Constantes.APLICACION)));
		// urlADFileUpload
		configuracion.setUrlADFileUpload(PropertiesUtil
				.getProperty(PropertiesUtil.URL_SUBIDA_DOCUMENTOS));

		// id certificado (ponemos el 0071)
		configuracion.setIdSigningCertificate(PropertiesUtil
				.getProperty(PropertiesUtil.SIGNING_CERT_ID_APPLET));

		// documentalType
		configuracion
				.setDocumentalType(ConstantesDokusi.TIPO_DOCUMENTAL_ARCHIVO);
		// auditUser
		configuracion.setAuditUser(UtilSeguridad.getInstance().getAuditUser());
		// acl
		configuracion.setAcl(ConstantesDokusi.ACL);
		// ejgv_origen
		configuracion
				.setEjgvOrigen(ConstantesDokusi.META_ORIGEN_ADMINISTRACION);
		// title
		configuracion.setTitle("Prueba Digitalización Segura");
		// ejgv_serie
		String terape = (String) session.getAttribute("terape");

		// obtener la serie documental en función del tipo de documento
		String serieDoc = "";
		String docType = (String) session.getAttribute("docType");
		if (Constantes.APE.equals(docType)) {
			serieDoc = DokusiUtils.getInstance()
					.obtenerSerieDocumentalAperturas(terape);
		} else {
			serieDoc = DokusiUtils.getInstance().obtenerSerieDocumentalOS(
					terape);
		}

		configuracion.setEjgvSerie(serieDoc);
		// object_name
		configuracion.setObjectName("Prueba Digitalización Segura");
		// ejgv_expediente
		// configuracion.setEjgvExpediente("PJU-1019/2015-XXVII"); // lo
		// omitimos
		// ejgv_tipo_indexacion
		configuracion.setEjgvTipoIndexacion("none");
		// javascriptResult
		configuracion.setJavascriptResult(PropertiesUtil
				.getProperty(PropertiesUtil.JAVASCRIPT_RESULT));

		String resultado = null;
		try {
			resultado = configuracion.getXMLToApplet();
		} catch (ParserConfigurationException e) {
			DigitalizacionController.LOGGER.error(
					"ERROR -> obtener XML --> generar XML", e);
		}

		res.setContentType("text/xml");
		BufferedOutputStream buf = null;
		try {
			buf = new BufferedOutputStream(res.getOutputStream());
			buf.write(resultado.getBytes("UTF-8"));
			res.flushBuffer();
		} catch (Exception e) {
			DigitalizacionController.LOGGER.error(
					"ERROR -> obtener XML --> generar fichero", e);
		} finally {
			if (buf != null) {
				try {
					buf.close();
				} catch (IOException e) {
					DigitalizacionController.LOGGER
							.error("ERROR -> obtener XML --> generar fichero - buf.close()",
									e);
				}
			}
		}
	}

	/**
	 * Obtener XML string.
	 * 
	 * String
	 * 
	 * @return the string
	 */
	@RequestMapping(value = "/obtenerXMLString", method = RequestMethod.GET)
	public @ResponseBody()
	String obtenerXMLString() {

		ConfigDigitalizacion configuracion = new ConfigDigitalizacion();
		// integrationToken
		configuracion.setIntegrationToken(UtilSeguridad.getInstance()
				.dom2String(
						UtilSeguridad.getInstance().getTokenDocumentXLNets(
								Constantes.APLICACION)));
		// urlADFileUpload
		configuracion.setUrlADFileUpload(PropertiesUtil
				.getProperty(PropertiesUtil.URL_SUBIDA_DOCUMENTOS));
		// idSigningCertificate
		/*
		 * configuracion.setIdSigningCertificate(TramitacionXMLUtil
		 * .obtenerCertificadoFirmaDelegacion(Constantes.DEL_ALAVA));
		 */

		// documentalType
		configuracion.setDocumentalType("ejgv_d_acuserecibo");
		// auditUser
		configuracion.setAuditUser(UtilSeguridad.getInstance().getAuditUser());

		// acl
		configuracion.setAcl(ConstantesDokusi.ACL);
		// ejgv_origen
		configuracion.setEjgvOrigen("ADMINISTRACION");
		// title
		configuracion.setTitle("Prueba Digitalización Segura");
		// ejgv_serie
		configuracion.setEjgvSerie(PropertiesUtil
				.getProperty(PropertiesUtil.SERIE_DOCUMENTAL_DOKUSI_APERTURAS));
		// object_name
		configuracion.setObjectName("Prueba Digitalización Segura");
		// ejgv_expediente
		configuracion.setEjgvExpediente("PJU-1019/2015-XXVII");
		// ejgv_tipo_indexacion
		configuracion.setEjgvTipoIndexacion("none");
		// javascriptResult
		configuracion.setJavascriptResult(PropertiesUtil
				.getProperty(PropertiesUtil.JAVASCRIPT_RESULT));

		String resultado = null;
		try {
			resultado = configuracion.getXMLToApplet();
		} catch (Exception e) {
			DigitalizacionController.LOGGER.error(
					"ERROR --> obtener XML en String", e);
		}
		return resultado;
	}

	/**
	 * oid String.
	 * 
	 * @param oid
	 *            the oid
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@RequestMapping(value = "/descargarDocumento", method = RequestMethod.GET)
	public void descargarDocumento(
			@RequestParam(value = "oid", required = false) String oid)
			throws AB04BException {

		T65BStringListType t65bStringListType = new T65BStringListType();
		t65bStringListType.getElement().add(ConstantesDokusi.META_SERIE);
		t65bStringListType.getElement().add(ConstantesDokusi.META_TITULO);
		t65bStringListType.getElement().add(ConstantesDokusi.META_NOMBRE);
		t65bStringListType.getElement().add("ejgv_id_firmantes");
		t65bStringListType.getElement().add("ejgv_nom_firmantes");

		String auditUser = UtilSeguridad.getInstance().getAuditUser();

		DocumentoAperturas doc = new DocumentoAperturas();
		doc.setOidDokusi065(oid);
		doc.setNombreDoc065("nombre.pdfa");

		FileOutputStream fileOutputStream = null;
		try {
			T65BDocumentType document = this.dokusiService.recuperarDocumento(
					auditUser, doc, t65bStringListType);

			fileOutputStream = new FileOutputStream(
					"C:\\Users\\Administrador\\Desktop\\DocDigitalizado.pdf");
			// TODO método deprecado
			fileOutputStream.write(document.getContent().getContent());
		} catch (Exception e) {
			DigitalizacionController.LOGGER.error(
					"ERROR al descargar documento", e);
		} finally {
			try {
				fileOutputStream.close();
			} catch (IOException e) {
				DigitalizacionController.LOGGER
						.error("ERROR al descargar documento - fileOutputStream.close()",
								e);
			}
		}
	}
}
